from collections import namedtuple

# záznam o filmu
Film = namedtuple('FilmInfo', 'název, rok, režisér, tržby')     # položky oddělené čárkou a mezerou

# načtení dat
filmy = []
with open('filmy_2.csv', mode='tr', encoding='utf-8') as soubor:
    for řádka in soubor:
        _, název, rok, režisér, tržby = řádka.strip().split(';')
        filmy.append(
            Film(název, rok, režisér, tržby)      # jedna pojmenovaná n-tice
        )
print(filmy)

# tisk dat
for film in sorted(filmy, key=lambda x: int(x.tržby[1:].replace(',', '_')), reverse=True):
    název, rok, režisér, tržby = film
    print(f'{název} ({rok}; r. {režisér}) => {tržby}')
